#!/tmp/busybox sh

FDISK="/tmp/busybox fdisk"
GREP="/tmp/busybox grep"
AWK="/tmp/busybox awk"
PS="/tmp/busybox ps"

expected_size="1228800"
block_root_dev="/dev/block/mmcblk0"
partition="mmcblk0p5"

partition_size=$($FDISK -l $block_root_dev | $GREP $partition | $AWK {'print $4'})

# Check for the 1200MB partition we expect to find.  Abort if we don't
if [ "$partition_size" != "$expected_size" ]; then
	# Second time here?
	if $($GREP show_text /cache/recovery/command > /dev/null); then
		# Yes, just exit with error
		echo "Partition $partition size of $partition_size != $expected_size"
		echo "Aborting install"
		exit 1
	fi

	# First time here:

	# Add the show_text command to recovery
	echo "--show_text" >> /cache/recovery/command
	# Zero out the recovery message block so it picks up our command change
	dd if=/dev/zero of=/dev/block/mmcblk0p8

	# Now, restart recovery so it will run us again with text displayed
	recovery=$($PS | $GREP recovery | $GREP -v grep | $AWK {'print $1'})
	kill $recovery
fi
